#include <cassert>
#include <cstdio>
#include <algorithm>

const long long INF = 100000000000000;

const int N = 200005;
int n, m;
long long x[N * 2], d, prev[N * 2];
std::pair<int, int> ev[N];

int locate(long long p) {
	return std::lower_bound(x, x + m, p) - x;
}

void update(long long cur, long long t) {
	long long R = INF, L = -INF;
	for (int i = 0; i < n && ev[i].first <= t; ++i) {
		if (ev[i].first + ev[i].second - d < t + cur && t + cur < ev[i].first + ev[i].second + d) 
			R = std::min(R, cur + t - ev[i].first);
		if (ev[i].first - ev[i].second - d < t - cur && t - cur < ev[i].first - ev[i].second + d) 
			L = std::max(L, cur - t + ev[i].first);
	}
	if (L > R) return;
	bool ok = 0;
	for (int i = 0; i < m; ++i) if (L <= x[i] && x[i] <= R) {
		if (x[i] >= cur && prev[i] + x[i] - cur <= t) ok = 1;
		if (x[i] < cur && prev[i] + cur - x[i] <= t) ok = 1;
	}
	if (ok) prev[locate(cur)] = std::min(prev[locate(cur)], t);
}

bool test() {
	for (int i = 0; i < n; ++i) {
		x[i << 1] = ev[i].second - d;
		x[i << 1 | 1] = ev[i].second + d;
	}
	x[n * 2] = 0;
	std::sort(x, x + n * 2 + 1);
	m = std::unique(x, x + n * 2 + 1) - x;
	for (int i = 0; i < m; ++i) prev[i] = INF;
	prev[locate(0)] = 0;
	for (int i = 0; i < n; ++i) {
		update(ev[i].second - d, ev[i].first);
		update(ev[i].second + d, ev[i].first);
		for (int j = 0; j < m; ++j) if (ev[i].second - d < x[j] && x[j] < ev[i].second + d) prev[j] = INF;
	}
	for (int i = 0; i < m; ++i) if (prev[i] != INF) return 1;
	return 0;
}

int main() {
	scanf("%d", &n);
	for (int i = 0; i < n; ++i) {
		scanf("%d%d", &ev[i].first, &ev[i].second);
		ev[i].first *= 2;
		ev[i].second *= 2;
	}
	std::sort(ev, ev + n);
	assert(test());
	long long l = 0, r = 40000000000;
	while (l < r) {
		d = l + r >> 1;
		if (test()) l = d + 1;
		else r = d;
	}
	--l;
	printf("%lld", l / 2);
	if (l & 1) printf(".5");
	printf("\n");
	return 0;
}